#version 330
#extension GL_EXT_gpu_shader4 : enable
//Waves of ball seaMod01.fsh by seven_dc
//https://www.shadertoy.com/view/fd2XDz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 40
#define MAX_DIST 50.
#define SURF_DIST .01
#define CLOSE_SURF_DIST .1

float smin( float a, float b, float k ) {
  float h = clamp( 0.5+0.5*(b-a)/k, 0., 1. );
  return mix( b, a, h ) - k*h*(1.0-h);
}

float GetDistance(vec3 point) {
	
    float texture = sin((iTime + point.x)*.2)*2.4+
        sin((iTime + point.x)*.25)*1.1+
        sin(point.z*2.5+sin(iTime)*.1)*.15+
        sin(point.x*5.+point.z*.015)*.41;
    
    float planeDist = point.y + texture*.5;
    
    vec4 sphere = vec4(1., 1., 1.5, 0.5);
    vec3 spoint = vec3(mod(point.x, 2.), point.y, mod(point.z, 3.));
    float sphereDist =  length(spoint-sphere.xyz)-sphere.w-sin(point.x+point.z+iTime)*.1;
    
    return smin(planeDist, sphereDist, .9);
}


vec3 GetNormal(vec3 point) {
  float distance = GetDistance(point);
  vec2 e = vec2(.01,0);
  
  vec3 normal = distance - vec3(
      GetDistance(point-e.xyy),
      GetDistance(point-e.yxy),
      GetDistance(point-e.yyx));
  
  return normalize(normal);
}

vec2 RayMarch(vec3 rayOrgin, vec3 rayDirection) {
	float distance=0.;
    
    int steps = MAX_STEPS; 
    int c = 0; // close of surface
    
    for(int i=0; i<steps; i++) {
    	vec3 point = rayOrgin + rayDirection * distance;
        float surfaceDistance = GetDistance(point);
        distance += surfaceDistance;
        
        if (distance<CLOSE_SURF_DIST) c++;
        // Stop marching if we go too far or we are close enough of surface
        if(distance>MAX_DIST || surfaceDistance<SURF_DIST) break;
    }
    
    return vec2(distance,c);
}

float GetLight(vec3 point, vec3 normal, vec3 lightPos) {    
  
  vec3 direction = normalize(lightPos-point);
  
  float dif = clamp(dot(normal, direction), 0., 1.);
  
  vec2 d = RayMarch(point+normal*.1, direction);
  if ( d.x < length(lightPos-point)) {
      dif *= .5;
  } else {
      dif -= d.y*.01;
  }
  
  return dif;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // put 0,0 in the center
    vec2 uv = (gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
       
    // camera   
    vec3 rayOrgin = vec3(0.-sin(iTime*.1), 3.5, 0);
    vec3 rayDirection = normalize(vec3(uv.x-sin(iTime*.1), uv.y-0.45, 1));

    vec2 d = RayMarch(rayOrgin, rayDirection);
    
    vec3 col = vec3(0.);
    
    vec3 lightPos = vec3(1.-sin(iTime*.1), 5.5, 1);
    
    if (d.x < 120.) {
        vec3 p = rayOrgin + rayDirection * d.x;
        vec3 n = GetNormal(p);
        float light = GetLight(p, n, lightPos);
        // color
        float dist = d.x/36.;
        col = vec3(
            light*0.9-dist,
            light*0.9-dist/1.5+(d.y*20.04),
            light-dist/2.5+(d.y*20.8)
        );
    }
    gl_FragColor = vec4(col,1.0);
}
